// linkList2.java
// demonstruje dziaanie listy powizanej
// uruchomienie programu: C>java LinkList2App
////////////////////////////////////////////////////////////////
class Link
   {
   public int iData;              // dane
   public double dData;           // dane
   public Link next;              // referencja do nastpnego poczenia
// -------------------------------------------------------------
   public Link(int id, double dd) // konstruktor
      {
      iData = id;                 // inicjalizacja danych
      dData = dd;                 // (pole next ma automatycznie warto null)
      }
// -------------------------------------------------------------
   public void displayLink()      // wypisuje warto pl
      {
      System.out.print("{" + iData + ", " + dData + "} ");
      }
   }  // koniec klasy Link
////////////////////////////////////////////////////////////////
class LinkList
   {
   private Link first;            // referencja do pierwszego elementu listy

// -------------------------------------------------------------
   public LinkList()              // konstruktor
      {
      first = null;               // lista nie ma jeszcze elementw
      }
// -------------------------------------------------------------
   public boolean isEmpty()       // zwraca true, jeeli lista jest pusta
      {
      return (first==null);
      }
// -------------------------------------------------------------
   public void insertFirst(int id, double dd)
      {                           // tworzymy nowe poczenie
      Link newLink = new Link(id, dd);
      newLink.next = first;       // newLink --> dotychczasowy pierwszy element
      first = newLink;            // first --> newLink
      }
// -------------------------------------------------------------
   public Link find(int key)      // wyszukiwanie elementu o zadanym kluczu
      {                           // (zakadamy, e lista nie jest pusta)
      Link current = first;              // rozpoczynamy od pierwszego elementu
      while(current.iData != key)        // dopki nie znaleziony...
         {
         if(current.next == null)        // jeeli koniec listy...
            return null;                 // ...nie znalelimy szukanego klucza
         else                            // jeeli nie...
            current = current.next;      // ...przechodzimy do nastpnego elementu
         }
      return current;                    // znalelimy element, zwracamy go
      }
// -------------------------------------------------------------
   public Link delete(int key)    // usuwanie elementu o zadanym kluczu
      {                           // (zakadamy, e lista nie jest pusta)
      Link current = first;              // szukamy elementu
      Link previous = first;
      while(current.iData != key)
         {
         if(current.next == null)
            return null;                 // nie znalelimy takiego klucza
         else
            {
            previous = current;          // przechodzimy do nastpnego elementu
            current = current.next;
            }
         }                               // znalelimy klucz
      if(current == first)               // jeeli jest to pierwszy element...
         first = first.next;             // ...zmieniamy pole first
      else                               // jeeli nie...
         previous.next = current.next;   // ...usuwamy go z listy
      return current;
      }
// -------------------------------------------------------------
   public void displayList()
      {
      System.out.print("Lista (pocztek-->koniec): ");
      Link current = first;       // zaczynamy na pocztku listy
      while(current != null)      // dopki nie koniec listy...
         {
         current.displayLink();   // ...wypisujemy dane i...
         current = current.next;  // ...przechodzimy do nastpnego elementu.
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   }  // koniec klasy LinkList
////////////////////////////////////////////////////////////////
class LinkList2App
   {
   public static void main(String[] args)
      {
      LinkList theList = new LinkList();  // tworzymy list

      theList.insertFirst(22, 2.99);      // wstawiamy 4 elementy
      theList.insertFirst(44, 4.99);
      theList.insertFirst(66, 6.99);
      theList.insertFirst(88, 8.99);

      theList.displayList();              // wypisujemy zawarto listy

      Link f = theList.find(44);          // szukamy elementu
      if( f != null)
         System.out.println("Znaleziono element o kluczu " + f.iData);
      else
         System.out.println("Nie znaleziono elementu");

      Link d = theList.delete(66);        // usuwamy element
      if( d != null )
         System.out.println("Usunito element o kluczu " + d.iData);
      else
         System.out.println("Nie mona usun elementu");

      theList.displayList();              // wypisujemy list
      }  // koniec main()
   }  // koniec klasy LinkList2App
////////////////////////////////////////////////////////////////
